/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.item.DamageableItem;
import io.github.fabricators_of_create.porting_lib.item.PiglinsNeutralItem;
import io.github.fabricators_of_create.porting_lib.item.WalkOnSnowItem;
import io.github.fabricators_of_create.porting_lib.item.api.extensions.RepairableItem;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.tool.addons.ToolActionItem;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemItemStorages;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class ModifiableArmorItem
extends class_1738
implements IModifiableDisplay,
DamageableItem,
PiglinsNeutralItem,
FabricElytraItem,
CustomEnchantingBehaviorItem,
WalkOnSnowItem,
ToolActionItem,
RepairableItem {
    public static final class_2960 PIGLIN_NEUTRAL = TConstruct.getResource("piglin_neutral");
    public static final class_2960 ELYTRA = TConstruct.getResource("elyta");
    public static final class_2960 SNOW_BOOTS = TConstruct.getResource("snow_boots");
    private final ToolDefinition toolDefinition;
    private class_1799 toolForRendering = null;

    public ModifiableArmorItem(class_1741 materialIn, class_1738.class_8051 slot, class_1792.class_1793 builderIn, ToolDefinition toolDefinition, class_5321<class_1761> tab) {
        super(materialIn, slot, builderIn);
        this.toolDefinition = toolDefinition;
        ((FabricItemSettings)builderIn).customDamage(this::damageItem);
        ItemGroupEvents.modifyEntriesEvent(tab).register(this::fillItemCategory);
        FluidStorage.ITEM.registerForItems((itemStack, context) -> new ToolFluidCapability((ContainerItemContext)context, (Supplier<? extends IToolStackView>)Lazy.of(() -> ToolStack.from(itemStack))), new class_1935[]{this});
        ItemItemStorages.ITEM.registerForItems((itemStack, context) -> ToolInventoryCapability.getCap(context, itemStack), new class_1935[]{this});
    }

    public ModifiableArmorItem(ModifiableArmorMaterial material, ArmorSlotType slotType, class_1792.class_1793 properties, class_5321<class_1761> tab) {
        this(material, slotType.getArmorType(), properties, Objects.requireNonNull(material.getArmorDefinition(slotType), "Missing tool definition for " + String.valueOf((Object)slotType)), tab);
    }

    public int getItemStackLimit(class_1799 stack) {
        return 1;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return enchantment.method_8195() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean makesPiglinsNeutral(class_1799 stack, class_1309 wearer) {
        return ModifierUtil.checkVolatileFlag(stack, PIGLIN_NEUTRAL);
    }

    public boolean canWalkOnPowderedSnow(class_1799 stack, class_1309 wearer) {
        return this.field_41933 == class_1738.class_8051.field_41937 && ModifierUtil.checkVolatileFlag(stack, SNOW_BOOTS);
    }

    public boolean canPerformAction(class_1799 stack, ToolAction toolAction) {
        return ModifierUtil.canPerformAction(ToolStack.from(stack), toolAction);
    }

    public void method_7860(class_2487 nbt) {
        ToolStack.verifyTag((class_1792)this, nbt, this.getToolDefinition());
    }

    public void method_7843(class_1799 stack, class_1937 levelIn, class_1657 playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public class_1271<class_1799> method_7836(class_1937 levelIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        class_1269 result = ToolInventoryCapability.tryOpenContainer(stack, null, this.getToolDefinition(), playerIn, Util.getSlotType(handIn));
        if (result.method_23665()) {
            return new class_1271(result, (Object)stack);
        }
        return super.method_7836(levelIn, playerIn, handIn);
    }

    public boolean method_7886(class_1799 stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public class_1814 method_7862(class_1799 stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return class_1814.values()[class_3532.method_15340((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(class_1799 stack) {
        return ModifierUtil.checkVolatileFlag(stack, INDESTRUCTIBLE_ENTITY);
    }

    public class_1297 createEntity(class_1937 level, class_1297 original, class_1799 stack) {
        if (ModifierUtil.checkVolatileFlag(stack, INDESTRUCTIBLE_ENTITY)) {
            IndestructibleItemEntity entity = new IndestructibleItemEntity(level, original.method_23317(), original.method_23318(), original.method_23321(), stack);
            entity.setPickupDelayFrom(original);
            return entity;
        }
        return null;
    }

    public boolean isRepairable(class_1799 stack) {
        return false;
    }

    public boolean method_7846() {
        return true;
    }

    public int getMaxDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(class_1799 stack, int damage) {
        if (this.method_7846()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T damager, Consumer<T> onBroken) {
        if (this.method_7846() && ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
        return 0;
    }

    public boolean method_31567(class_1799 pStack) {
        return ToolDamageUtil.showDurabilityBar(pStack);
    }

    public int method_31571(class_1799 pStack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(pStack);
    }

    public int method_31569(class_1799 pStack) {
        return ToolDamageUtil.getDamageForDisplay(pStack);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(IToolStackView tool, class_1304 slot) {
        if (slot != this.method_7685()) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            StatsNBT statsNBT = tool.getStats();
            UUID uuid = (UUID)field_7876.get(ArmorSlotType.equiptmentSlotToType(slot));
            builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "tconstruct.armor.armor", (double)statsNBT.get(ToolStats.ARMOR).floatValue(), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "tconstruct.armor.toughness", (double)statsNBT.get(ToolStats.ARMOR_TOUGHNESS).floatValue(), class_1322.class_1323.field_6328));
            double knockbackResistance = statsNBT.get(ToolStats.KNOCKBACK_RESISTANCE).floatValue();
            if (knockbackResistance != 0.0) {
                builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "tconstruct.armor.knockback_resistance", knockbackResistance, class_1322.class_1323.field_6328));
            }
            BiConsumer<class_1320, class_1322> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.ATTRIBUTES).addAttributes(tool, entry, slot, attributeConsumer);
            }
        }
        return builder.build();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        class_2487 nbt = stack.method_7969();
        if (slot != this.method_7685() || nbt == null) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public boolean useCustomElytra(class_1309 entity, class_1799 stack, boolean tickElytra) {
        if (this.method_7685() == class_1304.field_6174 && !ToolDamageUtil.isBroken(stack) && ModifierUtil.checkVolatileFlag(stack, ELYTRA)) {
            if (tickElytra) {
                this.elytraFlightTick(stack, entity, entity.method_6003());
            }
            return true;
        }
        return false;
    }

    public boolean elytraFlightTick(class_1799 stack, class_1309 entity, int flightTicks) {
        ToolStack tool;
        if (this.field_41933 == class_1738.class_8051.field_41935 && !(tool = ToolStack.from(stack)).isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getHook(TinkerHooks.ELYTRA_FLIGHT).elytraFlightTick(tool, entry, entity, flightTicks)) continue;
                return false;
            }
            if (!entity.method_37908().field_9236 && (flightTicks + 1) % 20 == 0) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, 1, entity, class_1304.field_6174);
            }
            return true;
        }
        return false;
    }

    public void method_7888(class_1799 stack, class_1937 levelIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        super.method_7888(stack, levelIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof class_1309) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!levelIn.field_9236) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                class_1309 living = (class_1309)entityIn;
                boolean isCorrectSlot = living.method_6118(this.method_7685()) == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), levelIn, living, itemSlot, isSelected, isCorrectSlot, stack);
                }
            }
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, level, tooltip, SafeClientAccess.getTooltipKey(), flag);
    }

    @Override
    public List<class_2561> getStatInformation(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltips, TooltipKey key, class_1836 tooltipFlag) {
        tooltips = TooltipUtil.getArmorStats(tool, player, tooltips, key.asMantle(), tooltipFlag);
        TooltipUtil.addAttributes(this, tool, player, tooltips, TooltipUtil.SHOW_ARMOR_ATTRIBUTES, this.method_7685());
        return tooltips;
    }

    @Override
    public List<class_2561> getStatInformation(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltips, slimeknights.mantle.client.TooltipKey key, class_1836 tooltipFlag) {
        tooltips = TooltipUtil.getArmorStats(tool, player, tooltips, key, tooltipFlag);
        TooltipUtil.addAttributes(this, tool, player, tooltips, TooltipUtil.SHOW_ARMOR_ATTRIBUTES, this.method_7685());
        return tooltips;
    }

    public int getDefaultTooltipHideFlags(class_1799 stack) {
        return TooltipUtil.getModifierHideFlags(this.getToolDefinition());
    }

    public void fillItemCategory(FabricItemGroupEntries items) {
        ToolBuildHandler.addDefaultSubItems(this, items, new MaterialVariantId[0]);
    }

    @Override
    public class_1799 getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((class_1792)this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

